﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Data;
using System.Configuration;

//our data access library
using DataAccess;

public class CUserDataXfer : CData
{
    /// <summary>
    /// US:5348 constructor
    /// </summary>
    /// <param name="data"></param>
    public CUserDataXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }

    /// <summary>
    /// US:5348 US:6047 transfer a user to the central db
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="strDUZ"></param>
    /// <param name="strUName"></param>
    /// <param name="strGreeting"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strUserClass"></param>
    /// <param name="lFXUserID"></param>
    /// <returns></returns>
    public CStatus SaveUser(long lXferSystemID,
                            string strDUZ,
                            string strLastName,
                            string strFirstName,
                            string strFirstLastName,
                            string strGreeting,
                            string strTitle,
                            long lRegionID,
                            long lSiteID,
                            string strUserClass,
                            out long lFXUserID)
    {
        lFXUserID = -1;

        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                          base.ClientIP,
                                                          base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_vDUZ", strDUZ);
        pList.AddInputParameter("pi_vLastName", strLastName);
        pList.AddInputParameter("pi_vFirstName", strFirstName);
        pList.AddInputParameter("pi_vFirstLastName", strFirstLastName);
        pList.AddInputParameter("pi_vGreeting", strGreeting);
        pList.AddInputParameter("pi_vTitle", strTitle);
        pList.AddInputParameter("pi_nRegionID", lRegionID);
        pList.AddInputParameter("pi_nSiteID", lSiteID);
        pList.AddInputParameter("pi_vUserClass", strUserClass);
        pList.AddOutputParameter("po_nUserID", lFXUserID);

        //execute the SP
        CStatus status = DBConn.ExecuteOracleSP("PCK_XFER.XferUser", pList);
        if (status.Status)
        {
            //get the returned ID from the SP call
            lFXUserID = pList.GetParamLongValue("po_nUserID");
        }

        return status;
    }



}
  